%%%============================================================
%%% Function smoothdata() -- Microsaccade Toolbox 0.9
%%% (R-language Version)
%%% Authors: Ralf Engbert, Petra Sinn, Konstantin Mergenthaler, 
%%% and Hans Trukenbrod
%%% Date: February 20th, 2014
%%%
%%% Converted to Matlab by Anna-Katharina Hauperich, 20th June 2019
%%%============================================================
function [xs] = smoothdataMSR(x,SAMPLING,TYPE)
x0 = x(1,:);
% SAMPLING=1;
%   TYPE=2;
v = vecvelMSR(x,SAMPLING,TYPE);
v(1,:) = v(1,:) + x0;
xs(:,1) = cumsum(v(:,1),'omitnan');
xs(:,2) = cumsum(v(:,2),'omitnan');

%% figure of smoothed and unsmoothed data
ff = 0;
if ff
    set(0,'DefaultFigureColor',[1 1 1])
figure
i{1} = subplot(1,2,1);
plot(x(:,1),x(:,2),'k')
daspect([1 1 1])
title('Unsmoothed data')

i{2} = subplot(1,2,2);
plot(xs(:,1),xs(:,2),'r')
daspect([1 1 1])
StandardiseAxisLims(i,1,1)
title('Smoothed data')
export_fig(['SmoothedData_MSR.png'], '-png', '-r400')
end



