%%%============================================================
%%% Function lagdist() -- Microsaccade Toolbox 0.9
%%% (R-language Version)
%%% Authors: Ralf Engbert, Petra Sinn, Konstantin Mergenthaler, 
%%% and Hans Trukenbrod
%%% Date: February 20th, 2014
%%%
%%% Converted to Matlab by Anna-Katharina Hauperich, 20th June 2019
%%%============================================================
%%%------------------------------------------------------------
%%% Time-lagged mean-square displacement estimator
%%% Engbert, R. & Kliegl, R. (2004) Microsaccades keep the eyes' 
%%% balance during fixation. Psychological Science, 15, 431-436.
%%%-------------------------------------------------------------
function [rv] = lagdistMSR(x) 
  N = length(x(:,1));
  maxlag = round(N/4);
  x1 = x;
  x2 = x;
  r = repmat(0,1,maxlag);
  for lag = 1:maxlag
    x1(1,:) = [];
    x2(end,:) = [];
    d =  x1 - x2;
    r(lag) = mean(d(:,1).^2+d(:,2).^2);
  end
  lag = 1:maxlag;
  rv = [lag',r'];
