%%%============================================================
%%% Function surrogate() -- Microsaccade Toolbox 0.9
%%% (R-language Version)
%%% Authors: Ralf Engbert, Petra Sinn, Konstantin Mergenthaler, 
%%% and Hans Trukenbrod
%%% Date: February 20th, 2014
%%%
%%% Converted to Matlab by Anna-Katharina Hauperich, 20th June 2019
%%%============================================================
function [xsur]= surrogateMSR(x,SAMPLING)
% SAMPLING=500
  x0 = x(1,:);
  v = vecvelMSR(x,SAMPLING,2);
  vsx = aaftMSR(v(:,1))/SAMPLING;
  vsy = aaftMSR(v(:,2))/SAMPLING;
  vsx(1) = vsx(1) + x0(1);
  vsy(1) = vsy(1) + x0(2);
  xs = cumsum(vsx);
  ys = cumsum(vsy);
  xsur = [xs,ys];
