%%% programme to compare correlations between speeds in left and right eye
%%% written by Anna-Katharina Hauperich, July 2019
%%
function [BinoCorr] = MS_BC_BinoCorr(VelocityLeft,VelocityRight, nsamples)

if mod(nsamples,2)
nsamples = nsamples+1;
end
%% find moving correlations in velocity
BinoCorr.CorVel = movcorr(VelocityLeft, VelocityRight, nsamples, 'Endpoints', 'discard');% movcorr is code by David J. Mack with it's own license included here in a separate folder
BinoCorr.CorVel = [NaN(nsamples/2,1); BinoCorr.CorVel; NaN((nsamples/2)-1,1)];
