%%% E2 Summarises microsaccade stats for each trial
%%% written by Anna-Katharina Hauperich, July 2019
%%
function   [MS] = MS_BC_StatsCreate(MSTag, Velocity, Distance, Acceleration, XData, YData, secscale)

%% Get all info
MSTag = double(MSTag);
MSTag(MSTag==0)=NaN;

% number of microsaccades
[Whensacc, WhensaccIdxSeparate, ~]= SeparateAtNan(MSTag);
if ~iscell(Whensacc)
    MS.NSacc = 0;
else
    MS.NSacc = length(Whensacc);
end
% frequency of microsaccades
MS.TrialDur = (secscale*length(MSTag));
MS.Freq = MS.NSacc/MS.TrialDur;

% indexes of beginning and end of each saccade
MS.IdxStart = NaN;
MS.IdxEnd = NaN;

% Microsaccade Maximum Velocity
MS.VelMax = NaN;
% Microsaccade Minimum Velocity
MS.VelMin = NaN;
% Microsaccade Mean velocity
MS.VelMean = NaN;
% Microsaccade Distance
MS.Dist = NaN;
% Microsaccade Duration
MS.Dur = NaN;
% Microsaccade start end distance
MS.DistSE = NaN;
% Microsaccade cumulative distance
MS.DistSum = NaN;
% Microsaccade largest rectangle distance
MS.DistRec = NaN; % what EK does, biggest difference in x and y
% Microsaccade Maximum Acceleration
MS.Acc = NaN;
%Acceleration minimum
MS.AccMin = NaN;
% Acceleration mean
MS.AccMean = NaN;
% Microsaccade Direction from start to end
MS.DirSE = NaN; % direction of microsaccade out of 360deg (calcualted first to last sample)


if MS.NSacc>0
    for n = 1:MS.NSacc
        %index of saccade
        MS.IdxStart(n) = WhensaccIdxSeparate{n}(1);
        MS.IdxEnd(n) =  WhensaccIdxSeparate{n}(end);
        while isnan(XData(MS.IdxEnd(n))) && MS.IdxEnd(n)>MS.IdxStart(n)
            MS.IdxEnd(n) = MS.IdxEnd(n)-1;
        end
        
        while isnan(XData(MS.IdxStart(n))) && MS.IdxEnd(n)>MS.IdxStart(n)
            MS.IdxStart(n) = MS.IdxStart(n)+1;
        end
        if MS.IdxEnd(n) ==MS.IdxStart(n)
            MS.VelMax(n) = NaN;
            MS.VelMin(n) = NaN;
            MS.VelMean(n) = NaN;
            MS.Acc(n) = NaN;
            MS.Dist(n) = NaN;
            MS.Dur(n) = NaN;
            MS.DistSE(n) = NaN;
            MS.DistSum(n) = NaN;
            MS.DistRec(n) = NaN;
            MS.AccMin(n) = NaN;
            MS.AccMean(n) = NaN;
            MS.DirSE(n) = NaN;

            
        else
            % Microsaccade Velocity
            MS.VelMax(n) = max(Velocity(WhensaccIdxSeparate{n}));
            MS.VelMin(n) = min(Velocity(WhensaccIdxSeparate{n}));
            MS.VelMean(n) = mean(Velocity(WhensaccIdxSeparate{n}));
            
            
            % Microsaccade  Acceleration
            MS.Acc(n) = max(Acceleration(WhensaccIdxSeparate{n}));
            MS.AccMin(n) = min(Acceleration(WhensaccIdxSeparate{n}));
            MS.AccMean(n) = mean(Acceleration(WhensaccIdxSeparate{n}));
            
            
            % Microsaccade Distance
            MS.DistSum(n) = sum(Distance(WhensaccIdxSeparate{n})); % sample to sample sum
            StartIdx = WhensaccIdxSeparate{n}(1);
            EndIdx = WhensaccIdxSeparate{n}(end);
            MS.DistSE(n) = sqrt((XData(StartIdx)-XData(EndIdx)).^2 +  (YData(StartIdx)- YData(EndIdx)).^2); % start end sum
            MaxX = max(XData(WhensaccIdxSeparate{n}));
            MinX = min(XData(WhensaccIdxSeparate{n}));
            MaxY = max(YData(WhensaccIdxSeparate{n}));
            MinY = min(YData(WhensaccIdxSeparate{n}));
            
            MS.DistRec(n) = pdist([MinX, MinY; MaxX, MaxY]);
            Allpoints=[NaN NaN];
            for d = 1:length(WhensaccIdxSeparate{n})
                Allpoints = [Allpoints; XData(WhensaccIdxSeparate{n}(d)), YData(WhensaccIdxSeparate{n}(d))];
            end
            MS.Dist(n) = max(max(pdist2(Allpoints, Allpoints))); % maximum distance between two points
            
            % Microsaccade Duration
            MS.Dur(n) = secscale*length(WhensaccIdxSeparate{n});
            
            % Microsaccade direction
            if ~(XData(StartIdx)==XData(EndIdx) && YData(StartIdx)==YData(EndIdx))
                MS.DirSE(n) = AngleInDegrees([XData(StartIdx) YData(StartIdx)], [XData(EndIdx) YData(EndIdx)]);
            else
                MS.DirSE(n) = NaN;
            end

        end
    end
end

