%%% Determine angle between two samples out of 360 and referenced to 0,0
%%% written by Anna-Katharina Hauperich, July 2019

function [angles] = SampleToSampleAngle(Xdata, Ydata)
angles = NaN(size(Xdata));
for k = 1:length(Xdata)-1
    angles(k) = AngleInDegrees([Xdata(k) Ydata(k)], [Xdata(k+1) Ydata(k+1)]);
    
end
%if no motion, assign previous motion direction
tag = find(angles ==999);
angles(tag) = angles(tag-1); 
