%%% gives out angle in degrees between 2 points in carthesian co-ordinates
%%% written by Anna-Katharina Hauperich, July 2019

function AngInDeg = AngleInDegrees(A,B)
x = A(1)-B(1);
y = A(2)-B(2);
if A(1)<B(1) && A(2)<B(2)
    AngInDeg = atan(x/y);
elseif A(1)<B(1) && A(2)>B(2)
    AngInDeg = pi +atan(x/y);
elseif A(1)>B(1) && A(2)<B(2)
    AngInDeg = 2*pi + atan(x/y);
elseif A(1)>B(1) && A(2)>B(2)
    AngInDeg = 1*pi + atan(x/y);
elseif sum([isnan(A) isnan(B)])>0
    AngInDeg = NaN;
elseif A(1) == B(1) && A(2) > B(2)
    AngInDeg = pi;
elseif  A(1) == B(1) && A(2) < B(2)
    AngInDeg = 2 * pi;
elseif A(1) > B(1) && A(2) == B(2)
    AngInDeg = 1.5*pi;
elseif  A(1) < B(1) && A(2) == B(2)
    AngInDeg = .5* pi;
elseif  A(1) == B(1) && A(2) == B(2)
    AngInDeg = 999;
end
AngInDeg = rad2deg(AngInDeg);

% up is 0, right is 90, down in 180 and left is 270

%% example inputs for testing
% A = [0 0]
% B = [0 1] %360
% B = [1 0] %90
% B = [1 1] %45
% B = [0 -1] %180
% B = [-1 0] %270
% B = [-1 -1] %225 
% 
% 
% 
% A = [0.1 0.1]
% B = [0 1] %353
% B = [1 0] %96
% B = [1 1] %45
% B = [0 -1] %185
% B = [-1 0] %264
% B = [-1 -1] %225



