%%% Demo script for how to extract microsaccades using the binocular
%%% correlation method
%%% written by Anna-Katharina Hauperich, July 2019
%% load in eye movement data
load('./OxfordDataset/EyeMovementDataP3.mat')

%% Recording Frequency
RecFreq = 1000;
%% Smooth data using Savitzky-Golay filter and exclude blink periods
MS_BC_DataPreProcessing(XLeft,YLeft,XRight,YRight, Blink, RecFreq)

%% Extract Parameters from smoothed data
% Velocity, acceleration, angle between samples, and distance between samples

MS_BC_ExtractParameters

%% Run Binocular Correlation
% either use fixed velocity threshold and windowsize:
% WindowSize = 65;
% VelocityThresh = .45;
% RemoveEndsFac = 2;

% or use fixed windowsize and median multiplier:
WindowSize = 75;
MedianMultiplier = 6;
VelocityThresh = [NaN MedianMultiplier]; %first value has to be NaN
RemoveEndsFac = 2;

MS_BC_BinocularCorrelation(WindowSize, VelocityThresh, RemoveEndsFac, RecFreq)

%% Get information about MS, plot positions and detected microsaccades and plot Main Sequence data 
MS_BC_InfoMainSequence


