%%% programme to apply scaling & remove blinks
%%% AKH, July 2019
function MS_BC_DataPreProcessing(XLeft, YLeft, XRight, YRight, Blink,RecFreq)
%% smoothing criteria
if RecFreq==1000
    CritData.framelength = 21;
    CritData.order = 3;
else
    CritData.framelength = input(['The recording frequency you requested is not the default 1000 Hz. What smoothing framelength would you like (Default: 21)?']);
    CritData.order = input(['The recording frequency you requested is not the default 1000 Hz. What smoothing order would you like (Default: 3)?']);
    
end

%% Remove blinks
whenblinkexclude = ones(size(Blink));
Blinks = ones(size(Blink));
Blinks(Blink==0) = NaN;
exbeginning = 200; %exclude 200millisec before blink
exend = 300; % exclude 300 millisec after blink
[~, BlinkPeriods, ~] = SeparateAtNan(Blinks');
if iscell(BlinkPeriods)
    for bp = 1:length(BlinkPeriods)
        SBlink(bp) = min(BlinkPeriods{bp})-exbeginning;
        EBlink(bp) = max(BlinkPeriods{bp})+exend;
        try %try, because blink could be occurring close to the end or beginning of the recording
            whenblinkexclude(SBlink(bp):EBlink(bp))=NaN; %exclude 250 millisec before and 550 millisec after
        end
    end
end
whenblinkexclude(length(XLeft)+1:end) = [];

dataSmooth.X.Left.Pos = XLeft.*whenblinkexclude;
dataSmooth.X.Right.Pos = XRight.*whenblinkexclude;
dataSmooth.Y.Left.Pos = YLeft.*whenblinkexclude;
dataSmooth.Y.Right.Pos = YRight.*whenblinkexclude;


%% smoothing SG
[dataSmooth.X.Left.Smooth.Pos, dataSmooth.X.Left.Smooth.Drv] = SavitzkyGolayDerivatives(dataSmooth.X.Left.Pos,CritData.order,CritData.framelength, 1000);
[dataSmooth.Y.Left.Smooth.Pos, dataSmooth.Y.Left.Smooth.Drv] = SavitzkyGolayDerivatives(dataSmooth.Y.Left.Pos,CritData.order,CritData.framelength, 1000);

[dataSmooth.X.Right.Smooth.Pos, dataSmooth.X.Right.Smooth.Drv] = SavitzkyGolayDerivatives(dataSmooth.X.Right.Pos,CritData.order,CritData.framelength, 1000);
[dataSmooth.Y.Right.Smooth.Pos, dataSmooth.Y.Right.Smooth.Drv] = SavitzkyGolayDerivatives(dataSmooth.Y.Right.Pos,CritData.order,CritData.framelength, 1000);

save('MS_PreProcessedData.mat', 'dataSmooth')