%%% Code that extracts parameters: velocity, acceleration, angle between samples and
%%% distance between samples
%%% written by Anna-Katharina Hauperich, July 2019
function MS_BC_ExtractParameters

%% Load in Smoothed data
load('MS_PreProcessedData.mat')
%% Parameter extraction
% Velocity
Velocity.X.Left = dataSmooth.X.Left.Smooth.Drv(:,1);
Velocity.Y.Left = dataSmooth.Y.Left.Smooth.Drv(:,1);

Velocity.X.Right = dataSmooth.X.Right.Smooth.Drv(:,1);
Velocity.Y.Right = dataSmooth.Y.Right.Smooth.Drv(:,1);

ParameterData.Left.Velocity = sqrt(Velocity.X.Left.^2 + Velocity.Y.Left.^2);
ParameterData.Right.Velocity = sqrt(Velocity.X.Right.^2 + Velocity.Y.Right.^2);

%Acceleration
Acceleration.X.Left = dataSmooth.X.Left.Smooth.Drv(:,2);
Acceleration.Y.Left = dataSmooth.Y.Left.Smooth.Drv(:,2);

Acceleration.X.Right = dataSmooth.X.Right.Smooth.Drv(:,2);
Acceleration.Y.Right = dataSmooth.Y.Right.Smooth.Drv(:,2);

ParameterData.Left.Acceleration = sqrt(Acceleration.X.Left.^2 + Acceleration.Y.Left.^2);
ParameterData.Right.Acceleration = sqrt(Acceleration.X.Right.^2 + Acceleration.Y.Right.^2);



% Anlge
ParameterData.Left.Angle = SampleToSampleAngle(dataSmooth.X.Left.Smooth.Pos', dataSmooth.Y.Left.Smooth.Pos');
ParameterData.Right.Angle = SampleToSampleAngle(dataSmooth.X.Right.Smooth.Pos', dataSmooth.Y.Right.Smooth.Pos');
ParameterData.Left.Angle(end+1) = NaN;
ParameterData.Right.Angle(end+1) = NaN;

ParameterData.Left.Angle = ParameterData.Left.Angle';
ParameterData.Right.Angle = ParameterData.Right.Angle';


% Sample to sample distance
for k = 1:length(dataSmooth.X.Left.Smooth.Pos)-1
    ParameterData.Left.Distance(k) = pdist([dataSmooth.X.Left.Smooth.Pos(k), dataSmooth.Y.Left.Smooth.Pos(k);dataSmooth.X.Left.Smooth.Pos(k+1), dataSmooth.Y.Left.Smooth.Pos(k+1)]);
end
ParameterData.Left.Distance(end+1) = NaN;
ParameterData.Left.Distance = ParameterData.Left.Distance';

for k = 1:length(dataSmooth.X.Right.Smooth.Pos)-1
    ParameterData.Right.Distance(k) = pdist([dataSmooth.X.Right.Smooth.Pos(k), dataSmooth.Y.Right.Smooth.Pos(k);dataSmooth.X.Right.Smooth.Pos(k+1), dataSmooth.Y.Right.Smooth.Pos(k+1)]);
end
ParameterData.Right.Distance(end+1) = NaN;
ParameterData.Right.Distance = ParameterData.Right.Distance';

%% Save parameters
save('MS_Parameters.mat', 'ParameterData')

