%%% extract microsaccade information and plot data
%%% written by Anna-Katharina Hauperich, July 2019

%% Load in data
load('MS_Parameters.mat')
load('MS_Tag.mat')
load('MS_CorrInfo.mat')
load('MS_PreProcessedData.mat')

%% make figure background white
set(0,'DefaultFigureColor',[1 1 1])
%% Extract Microsaccade information
if sum(Corr.Abs.CorrTag)>0
    [MSinfoCorr.Right.Smooth] = MS_BC_StatsCreate(Corr.Abs.CorrTag', ParameterData.Right.Velocity, ParameterData.Right.Distance, ParameterData.Right.Acceleration, dataSmooth.X.Right.Smooth.Pos, dataSmooth.Y.Right.Smooth.Pos, 1000);
    
    [MSinfoCorr.Left.Smooth] = MS_BC_StatsCreate(Corr.Abs.CorrTag', ParameterData.Left.Velocity, ParameterData.Left.Distance, ParameterData.Left.Acceleration, dataSmooth.X.Left.Smooth.Pos, dataSmooth.Y.Left.Smooth.Pos, 1000);
end
save('MS_Information.mat','MSinfoCorr')

%% Figure of smoothed positions, velocity correlations and detection thresholds
figure('units','normalized','outerposition',[0 0 1 1])
% find first microsaccade
FirstMS = find(MSTagBC,1);
range = FirstMS-100:FirstMS+2000;
while range(1)<1
    range(1) = [];
end

% Raw horizontal data
subplot(7,1,1)
plot(range,dataSmooth.X.Left.Pos(range),'k')
ylabel({'Raw'; 'Horizontal'; 'Position';  '[deg]'})
xlim([range(1) range(end)])

% Smoothed horizontal data
subplot(7,1,2)
plot(range,dataSmooth.X.Left.Smooth.Pos(range),'k')
ylabel({'Smoothed'; 'Horizontal'; 'Position';  '[deg]'})
xlim([range(1) range(end)])

% Raw vertical data
subplot(7,1,3)
plot(range,dataSmooth.Y.Left.Pos(range),'k')
ylabel({'Raw'; 'Vertical'; 'Position';  '[deg]'})
xlim([range(1) range(end)])

% Smoothed vertical data
subplot(7,1,4)
plot(range,dataSmooth.Y.Left.Smooth.Pos(range),'k')
ylabel({'Smoothed'; 'Vertical'; 'Position';  '[deg]'})
xlim([range(1) range(end)])

%Speed
subplot(7,1,5)
plot(range,ParameterData.Left.Velocity(range),'k')
ylabel({'Speed'; '[deg/sec]'})
xlim([range(1) range(end)])

%Speed correlations and speed correlation threshold
subplot(7,1,6)
hold on
plot(range,BinoCorr.CorVel(range),'k')
plot(range,ones(size(range)).*VelThresh,'k:')
legend({'Speed Correlation Profile', 'Threshold'}, 'Location', 'northeast')
ylabel('R')
xlim([range(1) range(end)])

%Detected microsaccades
subplot(7,1,7)
MSTag = Corr.Abs.CorrTag;
MSTag(Corr.Abs.CorrTag==0)=NaN;
plot(range,MSTag(range),'k', 'LineWidth',4)
ylabel({'Microsaccades'; 'detected'})
xlim([range(1) range(end)])
ylim([0 2])
yticks([])
xlabel('Sample Number')
%% Main Sequence
%plot microsaccade velocities against distance
figure
hold on
% Left Eye
plot(MSinfoCorr.Left.Smooth.Dist./(1/60),MSinfoCorr.Left.Smooth.VelMax,  'k*')
%Right Eye
plot(MSinfoCorr.Right.Smooth.Dist./(1/60),MSinfoCorr.Right.Smooth.VelMax,  'b*')
legend('Left', 'Right')
ylabel('Velocity (deg/sec)')
xlabel('Distance (arcmin)')
title('Main Sequence Binocular Correlation')
set(gca, 'XScale', 'log')
set(gca, 'YScale', 'log')

