%%% Function to apply Savitzky-Golay filter and get new positional derivatives
%%% written by Anna-Katharina Hauperich, July 2019
%%
function [SmoothedData, SmoothedDerivatives] = SavitzkyGolayDerivatives(Data,order,framelength, secscale)

[~,g] = sgolay(order,framelength);

dx = zeros(length(Data),4);
for p = 0:3 %number of derivatives
  dx(:,p+1) = conv(Data, factorial(p)/(-secscale)^p * g(:,p+1), 'same');
end
SmoothedData = dx(:,1);
SmoothedDerivatives = dx(:,2:end);
