%%% creates chunks of data lying in between NaN values
%%% written by Anna-Katharina Hauperich, July 2019

function [out, outidx, idx] = SeparateAtNan(DataIn)
%% careful is sensitive to direction of data, needs to be in row!

if sum(~isnan(DataIn))>0
% find the index of non-nan entries
idx = find(~isnan(DataIn));

% group all adjacent entries which are not nan to the next available index number
idx1 = cumsum([1,diff(idx)~=1]);

%
outidx = accumarray(idx1.',idx.',[],@(x) {x.'});
% accumulate them in a cell array
out = accumarray(idx1.',DataIn(idx).',[],@(x) {x.'});
else
    out = NaN;
    outidx = NaN;
    idx = NaN;
end